package step2; //if2008.mukas;

import java.awt.Graphics;
import java.awt.Image;

/**
 * A sprite to be displayed on the screen. Note that a sprite
 * contains no state information, i.e. its just the image and 
 * not the location. This allows us to use a single sprite in
 * lots of different places without having to store multiple 
 * copies of the image.
 * 
 */
public class Sprite {
	/** The image to be drawn for this sprite */
	private Image image;

	public Sprite(){
		this.image = null;
	}

	/**
	 * Create a new sprite based on an image
	 * 
	 */
	public Sprite(Image image) {
		this.image = image;
	}

	/**
	 * Get the width of the drawn sprite
	 * 
	 */
	public int getWidth() {
		return image.getWidth(null);
	}

	/**
	 * Get the height of the drawn sprite
	 * 
	 */
	public int getHeight() {
		return image.getHeight(null);
	}


	public void setImage(Image img){
		this.image = img;
	}

	public Image getImage(){
		return this.image;
	}

	/**
	 * Draw the sprite onto the graphics context provided
	 * The image is fitted into the rectangle given by x,y,w,h 
	 * 
	 */
	public void draw(Graphics g,int x,int y,int w, int h) {
		g.drawImage(image,x,y,w,h,null);
	}
}
