package step2; //if2008.mukas;

import step15.MukaGame;

/**
 * An entity which represents a predator.
 * 
 */
public class PredatorEntity extends Entity {
	
	/**
	 * Create a new predator entity
	 * 
	 */
	public PredatorEntity(String spriteClassname,int c,int r) {
		super(spriteClassname,c,r);
		
	}
	
	public void move() {
		// strategy: move on the dialogs

		this.move(1, 1);

		// adapt rows if border is reached and change direction
		if (colPos >= MukaGame.getNumCols()) {
			colPos = 0;
		}
		
		if (rowPos >= MukaGame.getNumRows()) {
				rowPos = 0;
		}
	}



	/**
	 * move dx columns and dy rows
	 */
	public void move(int dx, int dy) {
	    colPos +=dx;
	    while (colPos < 0)// if left border is exceeded
		colPos = colPos + MukaGame.getNumCols();
		
	    while (colPos > MukaGame.getNumCols()) // if right border is exceeded
		colPos = colPos - MukaGame.getNumCols();

	    rowPos+=dy;
	    while (rowPos < 0)
		rowPos = rowPos + MukaGame.getNumRows();
	    while (rowPos > MukaGame.getNumRows())
		rowPos = rowPos - MukaGame.getNumRows();
	}
	
	/**
	 * Notification that this alien has collided with another entity
	 * 
	 * @param other The other entity
	 */
	public void collidedWith(Entity other) {
		// collisions with aliens are handled elsewhere
	}
}
