package step2; //if2008.mukas;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;

/**
 * A sprite to be displayed on the screen. Note that a sprite
 * contains no state information, i.e. its just the image and 
 * not the location. This allows us to use a single sprite in
 * lots of different places without having to store multiple 
 * copies of the image.
 * 
 */
public class MyFirstSprite extends Sprite{

	public MyFirstSprite(){
		this.create();
	}


	private void create(){
		BufferedImage img = new BufferedImage(40,40,BufferedImage.TYPE_INT_RGB);
		Graphics g = img.getGraphics();
		g.setColor(new Color(255,0,0)); // just red
		g.fillRect(0,0,img.getWidth(),img.getHeight());
		g.setColor(new Color(255,202,58)); // some kind of yellow/orange
		g.fillOval(5,5,8,8);
		g.fillOval(25,5,8,8);
		int[] xPts = {10,15,25,30};
		int[] yPts = {25,30,30,25};
		g.drawPolyline(xPts,yPts,4);


		this.setImage((Image) img);
	}
}
