package step2; //if2008.mukas;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.util.ArrayList;

import javax.swing.JFrame;
import javax.swing.JPanel;


public class MukaGame  extends Canvas{

	/** The strategey that allows us to use accelerate page flipping */
	private BufferStrategy strategy;

	/** True if the game is currently "running", i.e. the game loop is looping */
	private boolean gameRunning = true;

	/** The board represents the fixed background of the game*/
	private Board board;;

	/** size of board shown in the canvas */
	public static int boardWidth = 800;
	public static int boardHeight = 600;

	/** muber of fields on the board depends on number of Rows and Number of Columns */
	public static int numRows = 15;
	public static int numCols = 20;

	/** The list of all the entities that exist in our game */
	private ArrayList entities = new ArrayList();


	/**
	 * Construct our game and set it running.
	 */
	public MukaGame() {
		// create a frame to contain our game
		JFrame container = new JFrame("Muka Game - IF 2008");

		// get hold the content of the frame and set up the resolution of the game
		JPanel panel = (JPanel) container.getContentPane();
		panel.setPreferredSize(new Dimension(boardWidth,boardHeight));
		panel.setLayout(null);

		// setup our canvas size and put it into the content of the frame
		setBounds(0,0,boardWidth,boardHeight);
		panel.add(this);

		// Tell AWT not to bother repainting our canvas since we're
		// going to do that our self in accelerated mode
		setIgnoreRepaint(true);

		// finally make the window visible 
		container.pack();
		container.setResizable(false);
		container.setVisible(true);

		// add a listener to respond to the user closing the window. If they
		// do we'd like to exit the game
		container.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});

		// add a key input system (defined below) to our canvas
		// so we can respond to key pressed
		//addKeyListener(new KeyInputHandler());

		// request the focus so key events come to us
		//requestFocus();

		// create the buffering strategy which will allow AWT
		// to manage our accelerated graphics
		createBufferStrategy(2);
		strategy = getBufferStrategy();

		// initialise the entities in our game so there's something
		// to see at startup
		initEntities();
	}

	private void initEntities() {
		this.board = new Board((int)this.getBounds().getWidth(),(int)this.getBounds().getHeight(),numCols, numRows);

		PredatorEntity predE = new PredatorEntity("step2.MyPredefinedSprite",10,7);
		entities.add(predE);
		
		MukaEntity mukE = new MukaEntity("step2.MyFirstSprite", 2,2);
		entities.add(mukE);
	}

	public void gameLoop() {
		long lastLoopTime = System.currentTimeMillis();

		// keep looping round til the game ends
		while (gameRunning) {
			Graphics2D g = (Graphics2D) strategy.getDrawGraphics();

			this.board.draw(g);
			// cycle round drawing all the entities we have in the game
			for (int i=0;i<entities.size();i++) {
				Entity entity = (Entity) entities.get(i);

				entity.draw(g);
			}

			g.dispose();
			strategy.show();

			// finally pause for a bit. Note: this should run us at about
			// 100 fps but on windows this might vary each loop due to
			// a bad implementation of timer
			try { Thread.sleep(10); } catch (Exception e) {}
		}
	}

	public static int getNumCols(){
		return numCols;
	}

	public static int getNumRows(){
		return numRows;
	}

	// utility method provided for convenience, returning the width if each field on the board
	public static int getFieldWidth(){
		return (int) (boardWidth / numCols);
	}
//	utility method provided for convenience, returning the height if each field on the board
	public static int getFieldHeight(){
		return (int) (boardHeight / numRows);
	}

	public static void main(String argv[]) {
		MukaGame mg =new MukaGame();

		// Start the main game loop, note: this method will not
		// return until the game has finished running. Hence we are
		// using the actual main thread to run the game.
		mg.gameLoop();
	}
}
