package step2; //if2008.mukas;

import step15.MukaGame;


/**
 * An entity which represents a muka.
 * 
 */
public class MukaEntity extends Entity {
	private int strength = 20; // strength parameter (can grow or shrink)
	private boolean toTheRight = true;
	
	/**
	 * Create a new Muka entity
	 * 
	 */
	public MukaEntity(String spriteClassname, int c, int r) {
		super(spriteClassname,c,r);

	}

	public void move() {
		// strategy: from right to left until the end of the board and then in 
		// a lower row from left to right until the bottom of the board and then
		// up, again

		int dx=0;
		if (toTheRight == true) {
			dx = 1;
		}
		else {
			dx = -1;
		}
		this.move(dx, 0);

		// adapt rows if border is reached and change direction
		boolean changeRow = false;
		if (colPos == MukaGame.getNumCols()) {
			toTheRight = false;
			changeRow = true;
		}
		else if (colPos == 0) {
			toTheRight = true;
			changeRow = true;
		}

		if (changeRow == true) {
			if (rowPos < MukaGame.getNumRows()) {
				// go further down
				rowPos++;
			}
			else {
				// back to top
				rowPos = 0;
			}
		}
	}


}
