package step2; //if2008.mukas;

import java.awt.Graphics;

/**
 * An entity represents any element that appears in the game. The
 * entity is responsible for resolving collisions and movement
 * based on a set of properties defined either by subclass or externally.
 * 
 * Note that doubles are used for positions. This may seem strange
 * given that pixels locations are integers. However, using double means
 * that an entity can move a partial pixel. It doesn't of course mean that
 * they will be display half way through a pixel but allows us not lose
 * accuracy as we move.
 * 
 */
public abstract class Entity {
	/** The current column position of this entity */ 
	protected int colPos;
	/** The current row location of this entity */
	protected int rowPos;
	/** The sprite that represents this entity */
	protected Sprite sprite;

	/**
	 * Construct an entity based on a sprite image and a location.
	 * 
	 */
	public Entity(String spriteClassName,int c,int r) {
		// create an instance of the sprite via the full classname
		// any classes mentioned must be a subclass of Sprite
		try {
			this.sprite = (Sprite)Class.forName(spriteClassName).newInstance();
			this.colPos = c;
			this.rowPos = r;
		}
		catch(java.lang.ClassNotFoundException e1){
			System.err.println("Class " + spriteClassName + " not found");
			e1.printStackTrace();
		}
		catch(java.lang.InstantiationException e2){
			System.err.println("Could not instantiate class " + spriteClassName);
			e2.printStackTrace();
		}
		catch(java.lang.IllegalAccessException e3){
			e3.printStackTrace();
		}
	}

	/**
	 * move dx columns and dy rows
	 */
	public void move(int dx, int dy) {
	}


	/**
	 * Draw this entity to the graphics context provided
	 * 
	 * @param g The graphics context on which to draw
	 */
	public void draw(Graphics g) {
		sprite.draw(g, 
				colPos * MukaGame.getFieldWidth()+1, 
				rowPos * MukaGame.getFieldHeight()+1,
				MukaGame.getFieldWidth()-1,
				MukaGame.getFieldHeight()-1);
	}

	/**
	 * Get the x location of this entity
	 * 
	 * @return The x location of this entity
	 */
	public int getColPos() {
		return  colPos;
	}

	/**
	 * Get the y location of this entity
	 * 
	 * @return The y location of this entity
	 */
	public int getRowPos() {
		return  rowPos;
	}

}
