package step2; //if2008.mukas;

import java.awt.Color;
import java.awt.Graphics;


public class Board {

	int boardWidth;
	int boardHeight;

	int numberOfHorizontalFields;
	int numberOfVerticalFields;

	Color bgColor = new Color(161,255,99);
	Color lineColor = Color.BLACK;

	public Board(int w, int h, int numHor, int numVert){
		this.boardWidth = w;
		this.boardHeight = h;

		numberOfHorizontalFields = numHor;
		numberOfVerticalFields = numVert;
	}


	public void draw(Graphics g) {
		g.setColor(bgColor);
		g.fillRect(0,0,boardWidth,boardHeight); // draw background

		g.setColor(lineColor);
		float dx = boardWidth / numberOfHorizontalFields;
		float dy = boardHeight / numberOfVerticalFields;

		// draw vertical lines for the seperation of the fields
		for (int i=0;i < boardWidth; i= (int) (i + dx))
			g.drawLine(i,0,i,boardHeight);
		// draw horizontal lines for the seperation of the fields
		for (int j=0;j < boardHeight; j = (int)(j+dy))
			g.drawLine(0,j,boardWidth,j);
	}

}
